pub mod file;

use actix_web::http::StatusCode;
use mongodb::{bson::doc, sync::Database};
use rhai::{plugin::EvalAltResult, Engine, ParseError, AST};
use std::collections::HashMap;

pub mod prelude {
    pub use super::file::*;
}

pub fn replace_chars(input: &str) -> String {
    let replacements = HashMap::from([
        ('#', "_fhas"),
        (':', "_fcol"),
        ('-', "_fdas"),
        ('@', "_fats"),
        ('!', "_fexl"),
        ('&', "_famp"),
        ('^', "_fcar"),
        ('~', "_ftil"),
    ]);

    let mut result = String::with_capacity(input.len());

    for c in input.chars() {
        if let Some(replacement) = replacements.get(&c) {
            result.push_str(replacement);
        } else {
            result.push(c);
        }
    }

    result
}

// pub fn route_to_fn(input: &str) -> String {
//     let input = super::replace_chars(input);
//     let re = Regex::new(r#"\{([^{}\s]+)\}"#).unwrap();
//     let re_dot = Regex::new(r"\.(\w+)").unwrap();
//
//     let result = re.replace_all(&input, |captures: &regex::Captures| {
//         let content = captures.get(1).map_or("", |m| m.as_str());
//         format!("_arg_{content}")
//     });
//
//     format!(
//         "_route_fmt_{}",
//         re_dot.replace_all(&result.replace("/", "_"), |captures: &Captures| format!("__d{}", rm_first(&captures[0])))
//     )
// }

pub fn collection_exists(d: &Database, name: &String) -> Result<bool, Box<EvalAltResult>> {
    let filter = doc! { "name": &name };

    match d.list_collection_names(Some(filter)) {
        Err(err) => Err(err.to_string().into()),
        Ok(list) => Ok(list.into_iter().any(|col| col == *name)),
    }
}

pub fn convert_status(code: i64) -> StatusCode {
    let u16_code = code as u16;
    StatusCode::from_u16(u16_code).unwrap_or(StatusCode::OK)
}

pub fn error(engine: &Engine, path: &str, err: ParseError) -> AST {
    match engine.compile(format!("fn {path}(){{text(\"error reading script file: {err}\")}}")) {
        Ok(ast) => ast,
        Err(_) => Default::default(),
    }
}
